/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul;

import com.ludwici.crumbslib.api.BlockHelper;
import com.ludwici.crumbslib.api.CreativeTabHelper;
import com.ludwici.crumbslib.api.CrumbSupplier;
import com.ludwici.crumbslib.api.EntityHelper;
import com.ludwici.crumbslib.api.ItemHelper;
import com.ludwici.crumbslib.api.MobEffectHelper;
import com.ludwici.crumbslib.api.PotionHelper;
import com.ludwici.crumbslib.api.TagHelper;
import com.ludwici.slimeoverhaul.GlowingSlimeBlock;
import com.ludwici.slimeoverhaul.effect.AntiDepthEffect;
import com.ludwici.slimeoverhaul.effect.BaseMobEffect;
import com.ludwici.slimeoverhaul.entity.custom.elementals.AirSlime;
import com.ludwici.slimeoverhaul.entity.custom.elementals.EarthSlime;
import com.ludwici.slimeoverhaul.entity.custom.elementals.FlameSlime;
import com.ludwici.slimeoverhaul.entity.custom.elementals.WaterSlime;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class Content {
    public static final CrumbSupplier<EntityType<AirSlime>> AIR_SLIME = EntityHelper.register((String)"air_slime", Content.getSlimeFactory(AirSlime::new));
    public static final CrumbSupplier<EntityType<WaterSlime>> WATER_SLIME = EntityHelper.register((String)"water_slime", (EntityType.Builder)Content.getSlimeFactory(WaterSlime::new).fireImmune());
    public static final CrumbSupplier<EntityType<EarthSlime>> EARTH_SLIME = EntityHelper.register((String)"earth_slime", Content.getSlimeFactory(EarthSlime::new));
    public static final CrumbSupplier<EntityType<FlameSlime>> FLAME_SLIME = EntityHelper.register((String)"flame_slime", (EntityType.Builder)Content.getSlimeFactory(FlameSlime::new).fireImmune());
    public static final CrumbSupplier<Item> AIR_SLIME_EGG = ItemHelper.registerSpawnEgg(AIR_SLIME, (int)0x93FFFF, (int)3321271);
    public static final CrumbSupplier<Item> WATER_SLIME_EGG = ItemHelper.registerSpawnEgg(WATER_SLIME, (int)2140116, (int)18329);
    public static final CrumbSupplier<Item> EARTH_SLIME_EGG = ItemHelper.registerSpawnEgg(EARTH_SLIME, (int)7222827, (int)2363403);
    public static final CrumbSupplier<Item> FLAME_SLIME_EGG = ItemHelper.registerSpawnEgg(FLAME_SLIME, (int)14376750, (int)12071433);
    public static final CrumbSupplier<Item> WATER_SLIME_BUCKET = ItemHelper.register((String)"water_slime_bucket", () -> new MobBucketItem((EntityType)WATER_SLIME.get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_AXOLOTL, new Item.Properties().stacksTo(1).component(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)));
    public static final CrumbSupplier<Item> FIRE_SLIME_BUCKET = ItemHelper.register((String)"fire_slime_bucket", () -> new MobBucketItem((EntityType)FLAME_SLIME.get(), (Fluid)Fluids.LAVA, SoundEvents.BUCKET_EMPTY_AXOLOTL, new Item.Properties().stacksTo(1).component(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY)));
    public static final CrumbSupplier<Item> AIR_SLIME_BALL = ItemHelper.register((String)"air_slime_ball", () -> new Item(new Item.Properties()));
    public static final CrumbSupplier<Item> WATER_SLIME_BALL = ItemHelper.register((String)"water_slime_ball", () -> new Item(new Item.Properties()));
    public static final CrumbSupplier<Item> EARTH_SLIME_BALL = ItemHelper.register((String)"earth_slime_ball", () -> new Item(new Item.Properties()));
    public static final CrumbSupplier<Item> FIRE_SLIME_BALL = ItemHelper.register((String)"fire_slime_ball", () -> new Item(new Item.Properties().fireResistant()));
    public static final CrumbSupplier<Block> AIR_SLIME_BLOCK = Content.registerSlimeBlock("air_slime_block");
    public static final CrumbSupplier<Block> WATER_SLIME_BLOCK = Content.registerSlimeBlock("water_slime_block");
    public static final CrumbSupplier<Block> EARTH_SLIME_BLOCK = Content.registerSlimeBlock("earth_slime_block");
    public static final CrumbSupplier<Block> FIRE_SLIME_BLOCK = Content.registerFireResistanceBlock("fire_slime_block", () -> new GlowingSlimeBlock(Content.getSlimeBlockProperties()));
    public static final TagKey<EntityType<?>> SLIMES = TagHelper.entityType((String)"slimes");
    public static final TagKey<EntityType<?>> ELEMENTAL_SLIMES = TagHelper.entityType((String)"elemental_slimes");
    public static final TagKey<Block> SLIME_BLOCK_ITEMS = TagHelper.block((String)"slime_blocks");
    public static final TagKey<Biome> AIR_SLIME_BIOME_TAG = TagHelper.biome((String)"entity_gen/is_air_slime_biome");
    public static final TagKey<Biome> WATER_SLIME_BIOME_TAG = TagHelper.biome((String)"entity_gen/is_water_slime_biome");
    public static final TagKey<Biome> EARTH_SLIME_BIOME_TAG = TagHelper.biome((String)"entity_gen/is_earth_slime_biome");
    public static final TagKey<Biome> FLAME_SLIME_BIOME_TAG = TagHelper.biome((String)"entity_gen/is_flame_slime_biome");
    public static final TagKey<BannerPattern> SLIME_BANNER_PATTERN = TagHelper.bannerPattern((String)"pattern_item/slime");
    public static final TagKey<BannerPattern> AIR_SLIME_SIGN_BANNER_PATTERN = TagHelper.bannerPattern((String)"pattern_item/air_slime_sign");
    public static final TagKey<BannerPattern> WATER_SLIME_SIGN_BANNER_PATTERN = TagHelper.bannerPattern((String)"pattern_item/water_slime_sign");
    public static final TagKey<BannerPattern> EARTH_SLIME_SIGN_BANNER_PATTERN = TagHelper.bannerPattern((String)"pattern_item/earth_slime_sign");
    public static final TagKey<BannerPattern> FIRE_SLIME_SIGN_BANNER_PATTERN = TagHelper.bannerPattern((String)"pattern_item/fire_slime_sign");
    public static final CrumbSupplier<MobEffect> DOUBLE_JUMP_EFFECT = MobEffectHelper.register((String)"double_jump", () -> new BaseMobEffect(MobEffectCategory.BENEFICIAL, 0x93FFFF));
    public static final CrumbSupplier<MobEffect> WATER_ANTI_DEPTH_EFFECT = MobEffectHelper.register((String)"water_anti_depth", () -> new AntiDepthEffect(MobEffectCategory.BENEFICIAL, (Fluid)Fluids.WATER, 2140116));
    public static final CrumbSupplier<MobEffect> KNOCK_BACK_EFFECT = MobEffectHelper.register((String)"knockback", () -> new BaseMobEffect(MobEffectCategory.BENEFICIAL, 7222827).addAttributeModifier(Attributes.KNOCKBACK_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"slimeoverhaul", (String)"knockback"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final CrumbSupplier<MobEffect> LAVA_ANTI_DEPTH_EFFECT = MobEffectHelper.register((String)"lava_anti_depth", () -> new AntiDepthEffect(MobEffectCategory.BENEFICIAL, (Fluid)Fluids.LAVA, 14376750));
    public static final CrumbSupplier<Potion> DOUBLE_JUMP_POTION = PotionHelper.register((String)"double_jump_potion", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(DOUBLE_JUMP_EFFECT.getHolder(), 1200, 0)}));
    public static final CrumbSupplier<Potion> WATER_ANTI_DEPTH_POTION = PotionHelper.register((String)"water_anti_depth_potion", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(WATER_ANTI_DEPTH_EFFECT.getHolder(), 1200, 0)}));
    public static final CrumbSupplier<Potion> KNOCKBACK_POTION = PotionHelper.register((String)"knockback_potion", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(KNOCK_BACK_EFFECT.getHolder(), 1200, 0)}));
    public static final CrumbSupplier<Potion> LAVA_ANTI_DEPTH_POTION = PotionHelper.register((String)"lava_anti_depth_potion", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(LAVA_ANTI_DEPTH_EFFECT.getHolder(), 1200, 0)}));
    public static final CrumbSupplier<Potion> MIDDLE_FIRE_RESISTANCE = PotionHelper.register((String)"middle_fire_resistance", () -> new Potion("fire_resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 6000)}));
    public static final CrumbSupplier<Potion> MIDDLE_WATER_BREATHING = PotionHelper.register((String)"middle_water_breathing", () -> new Potion("water_breathing", new MobEffectInstance[]{new MobEffectInstance(MobEffects.WATER_BREATHING, 6000)}));
    public static final CrumbSupplier<BannerPatternItem> PATTERN_SLIME = ItemHelper.registerBanner((String)"slime", SLIME_BANNER_PATTERN);
    public static final CrumbSupplier<BannerPatternItem> PATTERN_AIR_SLIME_SIGN = ItemHelper.registerBanner((String)"air_slime_sign", AIR_SLIME_SIGN_BANNER_PATTERN);
    public static final CrumbSupplier<BannerPatternItem> PATTERN_WATER_SLIME_SIGN = ItemHelper.registerBanner((String)"water_slime_sign", WATER_SLIME_SIGN_BANNER_PATTERN);
    public static final CrumbSupplier<BannerPatternItem> PATTERN_EARTH_SLIME_SIGN = ItemHelper.registerBanner((String)"earth_slime_sign", EARTH_SLIME_SIGN_BANNER_PATTERN);
    public static final CrumbSupplier<BannerPatternItem> PATTERN_FIRE_SLIME_SIGN = ItemHelper.registerBanner((String)"fire_slime_sign", FIRE_SLIME_SIGN_BANNER_PATTERN);
    public static final CrumbSupplier<CreativeModeTab> MAIN_TAB = CreativeTabHelper.register((String)"main", tab -> tab.title((Component)Component.literal((String)"Slime Overhaul")).icon(() -> ((Item)FLAME_SLIME_EGG.get()).getDefaultInstance()).displayItems((itemDisplayParameters, output) -> {
        output.accept((ItemLike)AIR_SLIME_BALL.get());
        output.accept((ItemLike)WATER_SLIME_BALL.get());
        output.accept((ItemLike)EARTH_SLIME_BALL.get());
        output.accept((ItemLike)FIRE_SLIME_BALL.get());
        output.accept((ItemLike)AIR_SLIME_BLOCK.get());
        output.accept((ItemLike)WATER_SLIME_BLOCK.get());
        output.accept((ItemLike)EARTH_SLIME_BLOCK.get());
        output.accept((ItemLike)FIRE_SLIME_BLOCK.get());
        output.accept((ItemLike)WATER_SLIME_BUCKET.get());
        output.accept((ItemLike)FIRE_SLIME_BUCKET.get());
        output.accept((ItemLike)PATTERN_SLIME.get());
        output.accept((ItemLike)PATTERN_AIR_SLIME_SIGN.get());
        output.accept((ItemLike)PATTERN_WATER_SLIME_SIGN.get());
        output.accept((ItemLike)PATTERN_EARTH_SLIME_SIGN.get());
        output.accept((ItemLike)PATTERN_FIRE_SLIME_SIGN.get());
        output.accept((ItemLike)AIR_SLIME_EGG.get());
        output.accept((ItemLike)WATER_SLIME_EGG.get());
        output.accept((ItemLike)EARTH_SLIME_EGG.get());
        output.accept((ItemLike)FLAME_SLIME_EGG.get());
    }));

    public static void registerPotions(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, ((Block)AIR_SLIME_BLOCK.get()).asItem(), DOUBLE_JUMP_POTION.getHolder());
        builder.addMix(Potions.AWKWARD, ((Block)WATER_SLIME_BLOCK.get()).asItem(), WATER_ANTI_DEPTH_POTION.getHolder());
        builder.addMix(Potions.AWKWARD, ((Block)EARTH_SLIME_BLOCK.get()).asItem(), KNOCKBACK_POTION.getHolder());
        builder.addMix(Potions.AWKWARD, ((Block)FIRE_SLIME_BLOCK.get()).asItem(), LAVA_ANTI_DEPTH_POTION.getHolder());
        builder.addMix(Potions.FIRE_RESISTANCE, ((Block)FIRE_SLIME_BLOCK.get()).asItem(), MIDDLE_FIRE_RESISTANCE.getHolder());
        builder.addMix(Potions.WATER_BREATHING, ((Block)WATER_SLIME_BLOCK.get()).asItem(), MIDDLE_WATER_BREATHING.getHolder());
    }

    public static void registerAnvilEvent(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.is(Tags.Items.TOOLS_SHIELD) && right.is((Item)EARTH_SLIME_BALL.get())) {
            ItemStack result = left.copy();
            CustomData data = (CustomData)result.get(DataComponents.CUSTOM_DATA);
            CompoundTag tag = data != null ? data.copyTag() : new CompoundTag();
            tag.putInt("bounce", 32);
            result.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            event.setOutput(result);
            event.setCost(3L);
            event.setMaterialCost(1);
        }
    }

    public static void spawns(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)AIR_SLIME.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AirSlime::checkSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)WATER_SLIME.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, WaterSlime::checkSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)EARTH_SLIME.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EarthSlime::checkSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
        event.register((EntityType)FLAME_SLIME.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.WORLD_SURFACE_WG, FlameSlime::checkSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    private static CrumbSupplier<Block> registerSlimeBlock(String name) {
        return BlockHelper.registerWithItem((String)name, () -> new GlowingSlimeBlock(Content.getSlimeBlockProperties()));
    }

    private static <T extends Block> CrumbSupplier<Block> registerFireResistanceBlock(String name, Supplier<T> supplier) {
        CrumbSupplier ret = BlockHelper.register((String)name, supplier);
        ItemHelper.register((String)name, () -> new BlockItem((Block)ret.get(), new Item.Properties().fireResistant()));
        return ret;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }

    private static BlockBehaviour.Properties getSlimeBlockProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).friction(0.8f).sound(SoundType.SLIME_BLOCK).noOcclusion().lightLevel(Content.litBlockEmission(8));
    }

    private static <T extends Entity> EntityType.Builder<T> getSlimeFactory(EntityType.EntityFactory<T> factory) {
        return EntityType.Builder.of(factory, (MobCategory)MobCategory.MONSTER).sized(0.52f, 0.52f).eyeHeight(0.325f).spawnDimensionsScale(4.0f).clientTrackingRange(10);
    }

    public static void init() {
    }
}

